<?php

/**
 * Copyright (c) Vincent Klaiber
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @see https://github.com/vinkla/extended-acf
 */

declare(strict_types=1);

namespace Extended\ACF\Fields;

use Extended\ACF\Fields\Settings\ConditionalLogic;
use Extended\ACF\Fields\Settings\FilterBy;
use Extended\ACF\Fields\Settings\HelperText;
use Extended\ACF\Fields\Settings\Multiple;
use Extended\ACF\Fields\Settings\Nullable;
use Extended\ACF\Fields\Settings\Required;
use Extended\ACF\Fields\Settings\Wrapper;

class PageLink extends Field
{
    use ConditionalLogic;
    use FilterBy;
    use HelperText;
    use Multiple;
    use Nullable;
    use Required;
    use Wrapper;

    protected string|null $type = 'page_link';

    public function disableArchives(): static
    {
        $this->settings['allow_archives'] = false;

        return $this;
    }
}
