{{--
  Template Name: Tarif
--}}

@extends('layouts.app')

@section('content')
	<x-blocks.page-hero :acf="$acf->page_header" />

	<section id="tarifs">

		<x-blocks.reassurance :items="$acf->reassurance" />

		<div id="tarifs-pres">
			<x-container>
				<div class="item">
					<div class="images">
						<x-image :image="$acf->presentation->images[0]" />
						<x-image :image="$acf->presentation->images[1]" />
					</div>
					<div class="content">
						<h2>{!! $acf->presentation->titre !!}</h2>
						<x-content :content="$acf->presentation->texte" />
					</div>
				</div>
			</x-container>
		</div>

		<div id="astuces">
			<x-container>
				<div class="left">
					<h2>{!! $acf->nos_astuces->title !!}</h2>
					<div class="content">{{ $acf->nos_astuces->subtitle }}</div>
				</div>
				<div class="repeat">
					@foreach ($acf->nos_astuces->repeat as $item)
						<div class="item">
							<svg xmlns="http://www.w3.org/2000/svg" width="25" height="26" viewBox="0 0 25 26" fill="none">
								<path
									d="M16.7688 12.2405L11.3628 6.57404L12.7881 5.08008L20.6271 13.2969L12.7881 21.5136L11.3628 20.0197L16.7688 14.3533H4.50195V12.2405H16.7688Z"
									fill="#1C1917" />
							</svg>
							<div class="right">
								<h3>{{ $item->title }}</h3>
								<p>{{ $item->suibtitle }}</p>
							</div>
						</div>
					@endforeach

				</div>
			</x-container>
		</div>

		<x-blocks.services-slider />

		<x-blocks.cta />

		<x-blocks.faq :acf="$acf->faq" />
	</section>
@endsection
