{{--
  Template Name: Réalisations
--}}

@extends('layouts.app')

@section('content')
	@php
		use App\View\Composers\App;
		$post_per_page = 8;
		$realisations = App::getPosts('realisation', ['numberposts' => $post_per_page]);
		$count = sizeof(App::getPosts('realisation', ['numberposts' => -1]));
	@endphp
	<x-blocks.page-hero :acf="$acf->page_header" />

	<div id="realisations-reassurance">
		<x-blocks.reassurance :items="$acf->reassurance" />
	</div>

	<section id="realisations">
		<x-container>
			<div class="header">
				<h2>{{ $acf->realisations->title }}</h2>
				<p>{{ $acf->realisations->subtitle }}</p>
			</div>

			<div id="realisations-gallery">
				<div class="gallery">
					@foreach ($realisations as $item)
						@include('partials.realisation-image', ['image' => $item->image])
					@endforeach
				</div>
			</div>

			@if ($count > 8)
				<button
					hx-post="{{ route('ajax.realisations') }}"
					hx-target="#realisations-gallery"
					hx-swap="beforeend"
					hx-trigger="click"
					hx-vals='{"offset": {{ $post_per_page }}}'
					hx-on::after-request="this.setAttribute('hx-vals', JSON.stringify({ offset: (JSON.parse(this.getAttribute('hx-vals')).offset + {{ $post_per_page }}) }))"
					aria-label="Voir plus"
					class="btn btn-shadow-white">
					Voir plus
				</button>
			@endif

		</x-container>
	</section>

	<section id="rea-cta" style="margin-bottom: 62px;">
		<x-blocks.cta />
	</section>

	<x-blocks.services-slider />

	<x-blocks.faq :acf="$acf->faq" />
@endsection
