{{--
  Template Name: Nous rejoindre
--}}

@extends('layouts.app')

@section('content')
	@php
		$jobs = App\View\Composers\App::getPosts('job', ['numberposts' => -1]);

		$jobTitle = '';
	@endphp
	<x-blocks.page-hero :acf="$acf->page_header" />

	<div x-data="{ @foreach ($jobs as $i => $job) open{{ $i }}: false, @endforeach }">

		<section id="jobs">
			<x-container>
				<h2>Découvrez nos métiers</h2>
				<div class="inner">
					<div>
						@foreach ($jobs as $i => $item)
							<accordion-element>
								<div class="ploiu-accordion-title">

									@if ($item->image)
										<x-acf.image :image="$item->image" />
									@endif
									<div class="inner-container">
										<h3>{{ $item->title }}</h3>
										<div class="qualities">
											@if (is_array($item->qualities))
												@foreach ($item->qualities as $quality)
													<div class="quality">
														<span>{{ $quality['text'] }}</span>
													</div>
												@endforeach
											@endif
										</div>
									</div>
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"
										data-slot="icon">
										<path fill-rule="evenodd"
											d="M12.53 16.28a.75.75 0 0 1-1.06 0l-7.5-7.5a.75.75 0 0 1 1.06-1.06L12 14.69l6.97-6.97a.75.75 0 1 1 1.06 1.06l-7.5 7.5Z"
											clip-rule="evenodd" />
									</svg>
								</div>
								<div>
									<div class="inner-container">
										<div class="text">
											<div class="title"><strong>Missions et Responsabilités : </strong></div>
											{!! $item->missions !!}
										</div>
										<div class="text">
											<div class="title"><strong>Profil et Compétences : </strong></div>
											{!! $item->profil !!}
										</div>
										<button class="btn btn-shadow-primary" aria-label="Postuler"
											@click="open{{ $i }} = true">
											Postuler
										</button>
									</div>
								</div>

							</accordion-element>
						@endforeach
					</div>
				</div>
			</x-container>
		</section>

		@foreach ($jobs as $i => $item)
			<div class="job-modal"
				x-show="open{{ $i }}"
				x-cloak
				@click.outside="open{{ $i }} = false">

				<div class="overlay" @click="open{{ $i }} = false"></div>
				<div class="content">
					<div>

						<span @click="open{{ $i }} = false" class="go-back">
							<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
								<path
									d="M2.87402 6.77295L6.89487 10.9128L5.83365 12.0031L0.00312108 6.00006L5.83989 0.00314297L6.89997 1.09459L2.87482 5.23017L12.0035 5.23491L12.0027 6.77769L2.87402 6.77295Z"
									fill="#00A1FF" />
							</svg>
							Retour à l'offre
						</span>
						<div class="close" @click="open{{ $i }} = false">
							<svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 26 26" fill="none">
								<line x1="19.0899" y1="6.36385" x2="6.362" y2="19.0918" stroke="#00A1FF" stroke-width="2" />
								<line x1="19.0898" y1="19.0919" x2="6.36185" y2="6.36395" stroke="#00A1FF" stroke-width="2" />
							</svg>
						</div>
						<h2>Postuler à cette offre </h2>
						<div class="modal-content-scrollable">
							{!! do_shortcode('[contact-form-7 id="5891e51" title="Candidature" job_title="{{ $item->title }}"]') !!}
						</div>
					</div>
				</div>
			</div>
		@endforeach

		<style>
			[x-cloak] {
				display: none !important;
			}
		</style>

		<section id="service-content">
			<x-container>
				@foreach ($acf->content as $item)
					<div class="item">
						<div>
							<h2>{!! $item->title !!}</h2>
							<x-content :content="$item->texte" />
						</div>
						@if ($item->image)
							<x-acf.image :image="$item->image" />
						@endif
					</div>
				@endforeach
			</x-container>
		</section>

	</div>
@endsection
