{{--
  Template Name: Contact
--}}

@extends('layouts.app')

@section('content')
	<x-blocks.page-hero :acf="$acf->page_header" />

	<section id="contact-info">
		<x-container>
			<div class="contact-info">
				<div class="contact-info__item">
					<h3>Adresse</h3>
					<p>{!! $options->address !!}</p>
				</div>
				<div class="contact-info__item">
					<h3>Téléphone</h3>
					<p><a href="tel:{{ $options->telephone }}">{{ $options->telephone }}</a></p>
				</div>
				<div class="contact-info__item">
					<h3>Email</h3>
					<p><a href="mailto:{{ $options->email }}">{{ $options->email }}</a></p>
				</div>
				<div class="contact-info__item">
					<h3>Horaires</h3>
					<p>{!! $options->horaires !!}</p>
				</div>
			</div>
		</x-container>
	</section>

	<section id="form-map">
		<x-container>
			<div>
				<div class="form">
					<h2>Nous contacter</h2>
					{!! do_shortcode('[contact-form-7 id="c06fc0d" title="Formulaire de contact"]') !!}
				</div>
				<x-mapbox />
			</div>
		</x-container>
	</section>
@endsection
