{{--
  Template Name: blog
--}}

@extends('layouts.app')

@section('content')
	<x-blocks.page-hero :acf="$acf->page_header" />

	<x-container>

		<div id='blog-filter'>
			<form
				hx-post="{{ $action }}"
				hx-target="{{ $target }}"
				hx-trigger="change"
				hx-indicator="#spinner"
				hx-swap='innerHTML'>

				<div class='radio-group'>
					<input
						id='all'
						type='radio'
						name='category'
						value='all'
						checked="checked" />
					<label for='all'>Tous</label>
				</div>

				@foreach (App\View\Composers\App::getTerms('category') as $key => $term)
					<div class='radio-group'>
						<input
							id='{{ $term->slug }}'
							type='radio'
							name='category'
							value='{{ $term->slug }}' />
						<label for='{{ $term->slug }}'>
							{{ $term->name }}
						</label>
					</div>
				@endforeach

			</form>
		</div>

		<div id='blog-cards'>

			<div class="inner">
				@foreach (\App\View\Composers\App::getPosts('post', ['numberposts' => $post_per_pages]) as $key => $item)
					<x-cards.post :post='$item' />
				@endforeach
			</div>

			<x-pagination
				action='{{ $action }}'
				target='{{ $target }}'
				number_of_pages='{{ ceil($count / $post_per_pages) }}'
				include="{{ $filterSelector }}" />

		</div>

	</x-container>
@endsection
