{{--
  Template Name: About
--}}

@extends('layouts.app')

@section('content')
	<x-blocks.page-hero :acf="$acf->page_header" />

	<section id="about-pres">
		<x-container>
			<div class="item">
				<div class="images">
					<x-image :image="$acf->presentation->gallery[0]" />
					<x-image :image="$acf->presentation->gallery[1]" />
				</div>
				<div class="content">
					<h2>{!! $acf->presentation->titre !!}</h2>
					<x-content :content="$acf->presentation->texte" />
					<x-acf.link class="btn btn-shadow" :acf="$acf->presentation->link" />
				</div>
			</div>
		</x-container>
	</section>

	<section id="chronology">
		<x-container>
			<header>
				<h2>{!! $acf->chronology->titre !!}</h2>
				<div class="pagination">
					<div class="button-prev">
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
							<path
								d="M7.8284 10.9999L13.1924 5.63589L11.7782 4.22168L4 11.9999L11.7782 19.778L13.1924 18.3638L7.8284 12.9999H20V10.9999H7.8284Z"
								fill="white" />
						</svg>
					</div>
					<div class="button-next">
						<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
							<path
								d="M16.4958 10.9999L11.1318 5.63589L12.546 4.22168L20.3242 11.9999L12.546 19.778L11.1318 18.3638L16.4958 12.9999H4.32422V10.9999H16.4958Z"
								fill="white" />
						</svg>
					</div>
				</div>
			</header>
			<div class="swiper">
				<div class="swiper-wrapper">
					@foreach ($acf->chronology->repeat as $item)
						<div class="swiper-slide">
							<div class="inner">
								<div class="date">
									{{ $formatDate($item->date) }}
								</div>
								<div class="titre">{{ $item->titre }}</div>
								<p class="subtitle">{{ $item->subtitle }}</p>
							</div>
						</div>
					@endforeach
				</div>
			</div>
		</x-container>
	</section>

	<section id="team">
		<x-container>
			<header>
				<h2>{!! $acf->equipe->title !!}</h2>
				<p>{!! $acf->equipe->subtitle !!}</p>
			</header>

			<div class="grid">
				@if ($acf->equipe->repeat)
					@foreach ($acf->equipe->repeat as $item)
						<div class="people">
							<x-image :image="$item->image" />
							<div class="content">
								<div class="name">{{ $item->name }}</div>
								<div class="role">{{ $item->role }}</div>
							</div>
						</div>
					@endforeach
				@endif
			</div>
		</x-container>
	</section>

	<section id="engagement">
		<x-container>
			<header>
				<x-suptitle :title="$acf->engagements->surtitre" />
				<h2>{{ $acf->engagements->titre }}</h2>
			</header>
			<div class="grid">
				@foreach ($acf->engagements->repeat as $item)
					<div class="item">
						<div class="title">{{ $item->titre }}</div>
						<p>{{ $item->texte }}</p>
					</div>
				@endforeach
			</div>
		</x-container>
	</section>

	<x-blocks.cta />
@endsection
