@extends('layouts.app')

@section('content')

	<div id="single-service">
		<x-blocks.page-hero :acf="$acf->page_header" />

		<x-blocks.reassurance :items="$acf->reassurance" />

		@if ($acf->content)
			<section id="service-content">
				<x-container>
					@foreach ($acf->content as $item)
						<div class="item">
							<div>
								<h2>{!! $item->title !!}</h2>
								<x-content :content="$item->texte" />
							</div>
							<x-image :image="$item->image" preset="container" />
						</div>
					@endforeach
				</x-container>
			</section>
		@endif

		<x-blocks.realisations-slider :acf="$acf->realisations" />

		<x-blocks.services-slider />

		<section id="service-cta" style="margin-bottom: 62px;">
			<x-blocks.cta />
		</section>

		<x-blocks.faq :acf="$acf->faq" />

		<div class="sticky-button">
			<a href="{{ get_permalink(16) }}" class="btn btn-primary">Demander un devis</a>
		</div>
	</div>

@endsection
