<section id="home-header">
	<x-image :image="$acf->header->image" sizes="100vw" loading="eager" decoding="sync" />
	<x-container>
		<div class="left">
			<x-image :image="$acf->header->image" sizes="100vw" loading="eager" decoding="sync" />
			<x-suptitle :title="$acf->header->suptitle" />
			<h1>{{ $acf->header->title }}</h1>
			<div class="text">{!! $acf->header->text !!}</div>
			<div class="text text_mobile">{!! $acf->header->text_mobile !!}</div>
		</div>
		<div class="form">
			<div class="title">{{ $acf->header->titre__form }}</div>
			{!! do_shortcode('[contact-form-7 id="3b194c9" title="Demande de devis ( home )"]') !!}
			<x-modals.form.success />
			<x-modals.form.failed />
		</div>
	</x-container>
</section>

<x-blocks.reassurance :items="$acf->reassurance" />

<x-blocks.services-slider />

<section id="home-presentation">
	<x-container>
		@foreach ($acf->presentations as $item)
			<div class="item">
				<h2>{!! $item->title !!}</h2>
				<div class="content">
					<x-content :content="$item->texte" />
					@if ($item->link)
						<x-acf.link class="btn btn-shadow" :acf="$item->link" />
					@endif
				</div>
				<div class="images">
					<x-image :image="$item->images[0]" sizes="400px" />
					<x-image :image="$item->images[1]" sizes="400px" />
				</div>
			</div>
		@endforeach
	</x-container>
</section>

<x-blocks.realisations-slider :acf="$acf->realisations" />

<div id="home-cta">
	<x-blocks.cta />
</div>

<x-blocks.reviews />

<x-blocks.faq :acf="$acf->faq" />
