@props(['target', 'action', 'number_of_pages', 'include'])

@php
	$current_page = $_GET['pg'] ?? 1;
	$base_url = $action;
@endphp

@if ($number_of_pages > 1)

	<div id="pagination"
		hx-target="{{ $target }}"
		hx-include="{{ $include }}">
		{{-- Prev Button --}}
		<button
			class='prev {{ $current_page > 1 ? '' : 'disabled' }}'
			hx-post="{{ $base_url }}?pg={{ $current_page - 1 }}"
			aria-label="Previous">
			<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
				<path d="M12.1716 12.0005L9.3431 14.8289L10.7574 16.2431L15 12.0005L10.7574 7.75781L9.3431 9.17203L12.1716 12.0005Z"
					fill="#292524" />
			</svg>
		</button>

		{{-- Page Links --}}
		<div class='page-links'>
			{{-- Always show the first page --}}
			<button
				hx-post="{{ $base_url }}?pg=1"
				class="{{ $current_page == 1 ? 'active' : '' }}"
				aria-label="Page 1">
				1
			</button>

			{{-- Show ellipsis if necessary (skip pages between first and current block) --}}
			@if ($current_page > 3)
				<span>...</span>
			@endif

			{{-- Show the pages around the current page (max 3 pages) --}}
			@for ($i = max(2, $current_page - 1); $i <= min($number_of_pages - 1, $current_page + 1); $i++)
				<button
					hx-post="{{ $base_url }}?pg={{ $i }}"
					class="{{ $i == $current_page ? 'active' : '' }}"
					aria-label="Page {{ $i }}">
					{{ $i }}
				</button>
			@endfor

			{{-- Show ellipsis if necessary (skip pages between current block and last page) --}}
			@if ($current_page < $number_of_pages - 2)
				<span>...</span>
			@endif

			{{-- Always show the last page --}}
			@if ($number_of_pages > 1)
				<button
					hx-post="{{ $base_url }}?pg={{ $number_of_pages }}"
					class="{{ $current_page == $number_of_pages ? 'active' : '' }}"
					aria-label="Page {{ $number_of_pages }}">
					{{ $number_of_pages }}
				</button>
			@endif
		</div>

		{{-- Next Button --}}
		<button
			class='next {{ $current_page < $number_of_pages ? '' : 'disabled' }}'
			hx-post="{{ $base_url }}?pg={{ $current_page + 1 }}"
			aria-label="Next">
			<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
				<path d="M12.1716 12.0005L9.3431 14.8289L10.7574 16.2431L15 12.0005L10.7574 7.75781L9.3431 9.17203L12.1716 12.0005Z"
					fill="#292524" />
			</svg>
		</button>
	</div>

@endif
