@props(['items' => []])
@php

	$gradient =
	    isset($acf->realisations->gradient_reassurance) && $acf->realisations->gradient_reassurance ? 'gradient' : '';
@endphp
@if ($items)
	<section id="reassurance" class={{ $gradient }}>
		<x-container>
			<div class=content data-layout="{{ count($items) }}">
				<div class="swiper">
					<div class="swiper-wrapper">
						@foreach ($items as $item)
							<div class="swiper-slide">
								<div class="inner">
									<div class="icon">
										@if ($item->image)
											<img src="{{ $item->image->url }}" alt="icon">
										@endif
									</div>
									<div class="right">
										<div class="title">{{ $item->title }}</div>
										<p>{{ $item->text }}</p>
									</div>
								</div>
							</div>
						@endforeach
					</div>
				</div>
			</div>
		</x-container>
	</section>
@endif
