@props(['acf' => []])

<sections id="realisations-slider">
	<x-container>
		<div class="header">
			<h2>{{ $acf->titre }}</h2>
			<p>{{ $acf->subtitle }}</p>
		</div>

		@if ($acf->relation)
			<div class="swiper">
				<div class="swiper-wrapper">
					@foreach ($acf->relation as $item)
						@php($item = App\View\Composers\App::getPost($item))
						<div class="swiper-slide">
							<div class="inner-slide">
								<x-image :image="$item->image" preset='card' />
								<p>{{ $item->title }}</p>
							</div>
						</div>
					@endforeach
				</div>
			</div>
		@endif
		@if ($acf->link)
			<x-acf.link class="btn btn-shadow-white" :acf="$acf->link" />
		@endif

	</x-container>
</sections>
