@props(['acf' => []])

<section id="page-hero" data-bg_color="{{ $acf->bg_color }}" data-gradient={{ $acf->gradient ? 'true' : 'false' }}
	data-type={{ $acf->type }}>

	@if ($acf->type === 'two_cols')
		<x-container>
			<div class="left">
				@if (!empty($acf->suptitle))
					<x-suptitle :title="$acf->suptitle" />
				@endif
				@if ($acf->title)
					<h1>{!! $acf->title !!}</h1>
				@endif
				@if (!empty($acf->subtitle))
					<div class="subtitle">{!! $acf->subtitle !!}</div>
				@endif
			</div>
			@if ($acf->image ?? false)
				<x-image :image="$acf->image" preset="half" loading="eager" decoding="sync" />
			@endif
		</x-container>
	@endif

	{{-- Full width --}}
	@if ($acf->type === 'full_width')
		<x-image :image="$acf->image" sizes="100vw" loading="eager" decoding="async" />
		<x-container>
			<h1>{!! $acf->title !!}</h1>
		</x-container>
	@endif
</section>
