import GLightbox from "glightbox";
import "glightbox/dist/css/glightbox.css";

export default function () {

  const runCond = document.querySelector('#realisations');
  if (!runCond) return;

  // Initialize lightbox
  let lightbox = initGlightbox();

  document.addEventListener('htmx:afterSwap', function (event) {
    if (lightbox) {
      lightbox.destroy();
    }

    // Wait a moment for the DOM to update
    setTimeout(() => {
      lightbox = initGlightbox();
    }, 50);

    console.log('htmx:afterSwap event triggered');
  });

  function initGlightbox() {
    return GLightbox({
      selector: '.glightbox',
      touchNavigation: true,
      loop: true,
      openEffect: 'fade',
      closeEffect: 'fade',
      slideEffect: 'slide',
      autoplay: false,
    });
  }

}