export default function () {
  const runCond = document.querySelector('#site-header');
  if (!runCond) return;

  const header = {
    init: function () {
      this.primaryMenu = runCond;
      this.nav = document.querySelector('.menus');
      this.menuItems = this.primaryMenu.querySelectorAll(':scope > .menu-item');
      this.openButton = document.getElementById('mobile-trigger');
      this.lastScrollTop = 0; // Stocke la dernière position de défilement

      this.attachEvents();
    },
    attachEvents: function () {
      document.addEventListener('scroll', () => {
        this.isScrolling();
      });

      document.addEventListener('click', (event) => {
        const target = event.target;
        if (!runCond.contains(target)) {
          this.resetMenuItems();
        }
        if (target.classList.contains('menu-item-has-children')) {
          target.classList.toggle('open');
        }
      });

      this.openButton.addEventListener('click', () => {
        this.primaryMenu.classList.toggle('menu-mobile-open');
        document.body.classList.toggle('no-scroll');
      });
    },
    isScrolling: function () {
      const scrollTop = window.scrollY;
      const isScrollingDown = scrollTop > this.lastScrollTop;

      // Ajouter la classe "scrolling" si on défile vers le bas
      if (scrollTop > 120) {
        this.primaryMenu.classList.add('scrolling');
        if (isScrollingDown) {
          this.primaryMenu.classList.add('scrolling-down');
          this.primaryMenu.classList.remove('scrolling-up');
        } else {
          this.primaryMenu.classList.add('scrolling-up');
          this.primaryMenu.classList.remove('scrolling-down');
        }
      } else {
        this.primaryMenu.classList.remove('scrolling', 'scrolling-down', 'scrolling-up');
      }

      this.lastScrollTop = scrollTop;
    },
    resetMenuItems: function () {
      const activeSubMenu = this.primaryMenu.querySelector('.menu-item.open');
      activeSubMenu && activeSubMenu.classList.remove('open');
    },
  };
  header.init();

}

