import Swiper from 'swiper';
import { Navigation } from 'swiper/modules';
import 'swiper/css';
import 'swiper/css/navigation';

export default function () {

  const runCond = document.querySelector('#services-slider');
  if (!runCond) return;

  new Swiper('#services-slider .swiper', {
    modules: [Navigation],
    navigation: {
      nextEl: '#services-slider .button-next',
      prevEl: '#services-slider .button-prev',
    },
    slidesPerView: 'auto',
    spaceBetween: 13,
    breakpoints: {
      900: {
        spaceBetween: 20,
      },
      990: {
        spaceBetween: 33
      }
    },
  });

}