import Swiper from 'swiper';
import { Navigation } from 'swiper/modules';

import 'swiper/css';
import 'swiper/css/navigation';

export default function () {

  const runCond = document.querySelector('#reviews');
  if (!runCond) return;

  new Swiper('#reviews .swiper', {
    slidesPerView: 1,
    spaceBetween: 24,
    breakpoints: {
      500: {
        slidesPerView: 'auto',
        spaceBetween: 24,
      },
      764: {
        slidesPerView: 'auto',
        spaceBetween: 40,
      },
    },
    modules: [Navigation],
    navigation: {
      nextEl: '#reviews .button-next',
      prevEl: '#reviews .button-prev',
    },
  });

}