import mapboxgl from 'mapbox-gl';
import 'mapbox-gl/dist/mapbox-gl.css';

export default function () {

  if (!document.querySelector('#map')) return;


  mapboxgl.accessToken = import.meta.env.VITE_MAPBOX_TOKEN;
  const map = new mapboxgl.Map({
    container: 'map',
    center: [mapData.lat, mapData.lng],
    style: mapData.style,
    zoom: 9
  });

  const marker1 = new mapboxgl.Marker({ color: mapData.markerColor })
    .setLngLat([mapData.lat, mapData.lng])
    .addTo(map);
}