<?php

function filter_pub()
{

    $posts_per_page = $_POST['nb'] ?? 10;
    $paged = $_GET['pg'] ?? 1;

    $tax_query = [];


    if (isset($_POST['category'])) {
        $tax_query[] = [
          'taxonomy' => 'cat_pub',
          'field' => 'slug',
          'terms' => $_POST['category'],
        ];
    }


    if (isset($_POST['years'])) {
        $tax_query[] = [
          'taxonomy' => 'date_publication',
          'field' => 'slug',
          'terms' => range($_POST['years'][0], $_POST['years'][1]),
          'operator' => 'IN',
          'include_children' => false
        ];
    }


    $args = [
      'post_type' => 'publication',
      'post_status' => 'publish',
      'orderby' => 'date',
      'order' => 'DESC',
      'posts_per_page' => $posts_per_page,
      'paged' => $paged,
      'tax_query' => $tax_query,
    ];

    $query = new WP_Query($args);

    // @return int
    $number_of_pages = ceil($query->found_posts / $posts_per_page);


    if ($query->found_posts > 0) {


        foreach ($query->posts as $actu) {
            echo view('components.cards.publication')
              ->with('post', App\View\Composers\App::getPost($actu));
        }

        echo view('components.pagination')
          ->with('action', 'filter_pub')
          ->with('target', '#publication-cards')
          ->with('number_of_pages', $number_of_pages)
          ->with('include', '#pub_filter form');

    } else {
        echo 'Aucune publication trouvée.';
    }
    wp_die();

}

add_action('wp_ajax_filter_pub', 'filter_pub');
add_action('wp_ajax_nopriv_filter_pub', 'filter_pub');
