<?php

namespace App\View\Composers;

use Roots\Acorn\View\Composer;
use WP_Query;

class Realisations extends Composer
{
    /**
     * List of views served by this composer.
     *
     * @var string[]
     */
    protected static $views = [
        'templates.template-realisations',
    ];

    public static function test() {

      return 'test';
    }

    public function handleLoadMore()
    {
      $offset = isset($_POST['offset']) ? intval($_POST['offset']) : 8;
      $posts_per_page = isset($_POST['posts_per_page']) ? intval($_POST['posts_per_page']) : 8;

      $query = new WP_Query([
        'post_type' => 'realisation',
        'posts_per_page' => $posts_per_page,
        'post_status' => 'publish',
        'offset' => $offset,
        'orderby' => 'date',
        'order' => 'DESC',
      ]);

      if ($query->have_posts()) {

        echo '<div class="gallery">';
        foreach($query->posts as $post) {
          $post = App::getPost($post);

          echo view('partials.realisation-image')
            ->with('image', $post->image)
            ->render();
        }
        echo '</div>';
      }

      $total_posts = wp_count_posts('realisation')->publish;
      if ($offset + $posts_per_page >= $total_posts) {
          echo "<script>document.querySelector('#realisations button').remove();</script>";
      }


    }
}
