<?php

namespace App\View\Composers;

use Roots\Acorn\View\Composer;

class Blog extends Composer
{
    /**
     * List of views served by this composer.
     *
     * @var string[]
     */
    protected static $views = [
        'templates.template-blog',
    ];

    public function with()
    {
        return [
          'count' => $this->getPostCount(),
          'action' => route('ajax.blog'),
          'target' => '#blog-cards',
          'post_per_pages' => 6,
          'filterSelector' => '#blog-filter form',
        ];
    }

     private function getPostCount()
    {
        return count(App::getPosts('post', ['numberposts' => -1]));
    }

    public function filter()
    {
        $paged = $_GET['pg'] ?? 1;

        $tax_query = [];

        if (isset($_POST['category']) && $_POST['category'] !== 'all') {
          $tax_query[] = [
              'taxonomy' => 'category',
              'field' => 'slug',
              'terms' => $_POST['category'],
          ];
        }

        $args = [
          'post_type' => 'post',
          'post_status' => 'publish',
          'orderby' => 'date',
          'order' => 'DESC',
          'posts_per_page' => $this->with()['post_per_pages'],
          'paged' => $paged,
          'tax_query' => $tax_query,
        ];

        $query = new \WP_Query($args);

        if ($query->found_posts > 0) {

          echo '<div class="inner">';
          foreach ($query->posts as $actu) {
              echo view('components.cards.post')
                ->with('post', App::getPost($actu))
                ->render();
          }
          echo '</div>';

           echo view('components.pagination')
            ->with('action', $this->with()['action'])
            ->with('target', $this->with()['target'])
            ->with('number_of_pages', ceil($this->getPostCount() / $this->with()['post_per_pages']))
            ->with('include', $this->with()['filterSelector']);

        } else {
            echo 'Aucune publication trouvée.';
        }
    }
}
