<?php

namespace App\View\Composers;

use Roots\Acorn\View\Composer;
use Roots\Acorn\View\Composers\Concerns\AcfFields;

class App extends Composer
{
    use AcfFields;

    /**
     * List of views served by this composer.
     *
     * @var array
     */
    protected static $views = [
      '*',
    ];

    /**
     * Data to be passed to view before rendering.
     *
     * @return array
     */
    public function with()
    {
        return [
          'acf' => json_decode(collect($this->fields())->toJson()),
          'options' => json_decode(collect($this->fields('options'))->toJson()),
          'siteName' => $this->siteName(),
        ];
    }

    /**
     * Returns the site name.
     *
     * @return string
     */
    public function siteName()
    {
        return get_bloginfo('name', 'display');
    }

    public static function getPost($post)
    {
        $post = get_post($post);
        $post_type = $post->post_type;
        $namespace = '\\App\Model\\';
        $model = $namespace . ucfirst(self::toCamelCase(strtolower($post_type)));
        return new $model($post);
    }

    public static function getPosts(string $postType, array $args): array
    {
        $params = array_merge(['post_type' => $postType, 'suppress_filters' => false], $args);
        $posts = get_posts($params);
        $posts_return = [];
        foreach ($posts as $post) {
            $posts_return[] = self::getPost($post);
        }
        return $posts_return;
    }

    public static function toCamelCase($input)
    {
        return str_replace(' ', '', ucwords(str_replace('-', ' ', $input)));
    }

    public static function getTerms(string $taxonomy)
    {
        $args = array_merge(['taxonomy' => $taxonomy], ['hide_empty' => false]);
        return get_terms($args);
    }
}
