<?php

namespace App\View\Composers;

use Roots\Acorn\View\Composer;

class About extends Composer
{
    /**
     * List of views served by this composer.
     *
     * @var string[]
     */
    protected static $views = [
         'templates.template-about',
    ];

    public function with()
    {
        return [
            'formatDate' => $this->formatDate(),
        ];
    }

    public function formatDate()
    {
        return fn($date) => \DateTime::createFromFormat('d/m/Y', $date) 
          ? mb_strtoupper(rtrim((new \IntlDateFormatter(
              'fr_FR',
              \IntlDateFormatter::NONE,
              \IntlDateFormatter::NONE,
              null,
              null,
              'MMM'
          ))->format(\DateTime::createFromFormat('d/m/Y', $date)), '.')) . '.' . \DateTime::createFromFormat('d/m/Y', $date)->format('y')
          : $date;
    }
}
