<?php

namespace App\Model;

use WP_Post;

class Post extends Model
{

  public $image;
  public $category;
  public $metadata;

    public function __construct(WP_Post $post)
    {
        parent::__construct($post);
        $this->image = json_decode(json_encode($this->getField('image')));
        $this->category = get_the_terms($this->post, 'category')[0];
        $this->metadata = $this->getField('meta');
    }
}