<?php

namespace App\Model;

use WP_Post;

class Model
{

    public $post;
    public $title;
    public $content;
    public $excerpt;
    public $date;


    public function __construct(WP_Post $post)
    {
        $this->post = $post;
        $this->title = $this->post->post_title;
        $this->content = $this->post->post_content;
        $this->excerpt = $this->post->post_excerpt;
        $this->date = get_the_date(get_option('date_format'), $this->post);
    }

    public function getField(string $name)
    {
      
      try {
        $value = \get_field($name, $this->post->ID); 

        // Return null if field doesn't exist or is empty
        return $value !== null && $value !== '' ? $value : null;

      } catch (\Exception $e) {
        
        // Log the error but don't break execution
        error_log('Error getting ACF field "' . $name . '": ' . $e->getMessage());
        return null;
    }
    }

    /**
     * Convert arrays to objects recursively
     *
     * @param array|mixed $array The array to convert
     * @return object|mixed An object representation of the array or the original value
     */
    protected function arrayToObject($array)
    {
        // Check if it's an array
        if (!is_array($array)) {
            return $array;
        }

        // Convert each array element recursively
        return (object) array_map([$this, 'arrayToObject'], $array);
    }
}