<?php

namespace App\Acf;

use Extended\ACF\Fields\Group;
use Extended\ACF\Fields\Image;
use Extended\ACF\Fields\Text;
use Extended\ACF\Fields\Textarea;
use Extended\ACF\Location;
use Extended\ACF\Fields\WYSIWYGEditor;

class SinglePostFields
{
  public static function register()
  {
    register_extended_field_group([
      'title' => 'Article',
      'fields' => [
        Image::make('Image', 'image')->format('array'),
        WYSIWYGEditor::make('Contenu', 'content'),
      ],
      'location' => [
        Location::where('post_type', 'post'),
      ],
      'style' => 'default',
      'position' => 'normal',
    ]);
  }
}