<?php

namespace App\Acf;

use Extended\ACF\Fields\Checkbox;
use Extended\ACF\Fields\Group;
use Extended\ACF\Fields\Image;
use Extended\ACF\Fields\Link;
use Extended\ACF\Fields\Select;
use Extended\ACF\Fields\Text;
use Extended\ACF\Fields\Textarea;
use Extended\ACF\Fields\TrueFalse;
use Extended\ACF\Location;

class PageHeroFields
{
    public static function register()
    {
        register_extended_field_group([
            'title' => 'Component : Page Header',
            'fields' => [
                Group::make('Page Header', 'page_header')
                  ->fields([
                    Select::make('Background', 'bg_color')
                      ->choices([
                        'default' => 'défaut',
                        'blue' => 'Bleu',
                      ]),
                      TrueFalse::make('Dégradé', 'gradient')
                        ->helperText('Afficher un dégradé quand background = Bleu')
                        ->default(false)
                        ->stylized(on: 'Yes'),
                      Select::make('type', 'type')
                      ->choices([
                          'two_cols' => '2 colonnes',
                          'full_width' => 'Pleine largeur'
                      ]),
                    Text::make('Sur-titre', 'suptitle'),
                    Text::make('Titre', 'title'),
                    Textarea::make('Sous-titre', 'subtitle')
                      ->newLines('br')
                      ->rows(8),
                    // Link::make('Lien', 'link'),
                    Image::make('Image', 'image')->format('array'),
                  ]),
            ],
            'location' => [
                  Location::where('post_type', 'page')
                    ->and('page_type', '!=', 'front_page')
                    ->and('page_template', '!=', 'templates/template-homebis.blade.php'),
                Location::where('post_type', 'service'),
            ],
            'style' => 'default',
            'position' => 'normal',
        ]);
    }
}