<?php

namespace App\Acf;

use Extended\ACF\Fields\Group;
use Extended\ACF\Fields\Text;
use Extended\ACF\Location;
use Symfony\Component\Console\Color;

class MapboxFields
{
  public static function register()
  {
    register_extended_field_group([
      'title' => 'Component : Mapbox',
      'fields' => [
        Group::make('Mapbox', 'mapbox')
          ->fields([
            Text::make('Latitude', 'lat'),
            Text::make('Longitude', 'lng'),
            Text::make('Zoom', 'zoom')->default('9'),
            Text::make('Style', 'style')->default('mapbox://styles/mapbox/streets-v12'),
            Text::make('Marker color', 'marker_color')->default('#000000'),
          ]),
      ],
      'location' => [
        Location::where('options_page', 'theme-general-settings'),
      ],
      'style' => 'default',
      'position' => 'normal',
    ]);
  }
}