<!doctype html>
<html <?php (language_attributes()); ?>>

<head>
	<!-- Google Tag Manager -->
	<script>
		(function(w, d, s, l, i) {
			w[l] = w[l] || [];
			w[l].push({
				'gtm.start': new Date().getTime(),
				event: 'gtm.js'
			});
			var f = d.getElementsByTagName(s)[0],
				j = d.createElement(s),
				dl = l != 'dataLayer' ? '&l=' + l : '';
			j.async = true;
			j.src =
				'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
			f.parentNode.insertBefore(j, f);
		})(window, document, 'script', 'dataLayer', 'GTM-MZ5Z6F4X');
	</script>
	<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php (do_action('get_header')); ?>
	<?php (wp_head()); ?>
	<link
		rel="preload"
		href="<?= \Roots\asset('fonts/fustat/Fustat-VariableFont_wght.woff2'); ?>"
		as="font"
		type="font/woff2"
		crossorigin="anonymous">
	<?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.scss', 'resources/js/app.js']); ?>
</head>

<body <?php (body_class()); ?>>
	<!-- Google Tag Manager (noscript) -->
	<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MZ5Z6F4X"
			height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
	<!-- End Google Tag Manager (noscript) -->
	<?php (wp_body_open()); ?>

	<div id="app">

		<?php echo $__env->make('sections.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

		<main id="main" class="main">
			<?php echo $__env->yieldContent('content'); ?>
		</main>

		<?php echo $__env->make('sections.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
	</div>

	<?php (do_action('get_footer')); ?>
	<?php (wp_footer()); ?>
</body>

</html>
<?php /**PATH /home/ldqrldg/preprod/web/app/themes/lorraine-resine/resources/views/layouts/app.blade.php ENDPATH**/ ?>