<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['target', 'action', 'number_of_pages', 'include']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['target', 'action', 'number_of_pages', 'include']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<?php
	$current_page = $_GET['pg'] ?? 1;
	$base_url = $action;
?>

<?php if($number_of_pages > 1): ?>

	<div id="pagination"
		hx-target="<?php echo e($target); ?>"
		hx-include="<?php echo e($include); ?>">
		
		<button
			class='prev <?php echo e($current_page > 1 ? '' : 'disabled'); ?>'
			hx-post="<?php echo e($base_url); ?>?pg=<?php echo e($current_page - 1); ?>"
			aria-label="Previous">
			<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
				<path d="M12.1716 12.0005L9.3431 14.8289L10.7574 16.2431L15 12.0005L10.7574 7.75781L9.3431 9.17203L12.1716 12.0005Z"
					fill="#292524" />
			</svg>
		</button>

		
		<div class='page-links'>
			
			<button
				hx-post="<?php echo e($base_url); ?>?pg=1"
				class="<?php echo e($current_page == 1 ? 'active' : ''); ?>"
				aria-label="Page 1">
				1
			</button>

			
			<?php if($current_page > 3): ?>
				<span>...</span>
			<?php endif; ?>

			
			<?php for($i = max(2, $current_page - 1); $i <= min($number_of_pages - 1, $current_page + 1); $i++): ?>
				<button
					hx-post="<?php echo e($base_url); ?>?pg=<?php echo e($i); ?>"
					class="<?php echo e($i == $current_page ? 'active' : ''); ?>"
					aria-label="Page <?php echo e($i); ?>">
					<?php echo e($i); ?>

				</button>
			<?php endfor; ?>

			
			<?php if($current_page < $number_of_pages - 2): ?>
				<span>...</span>
			<?php endif; ?>

			
			<?php if($number_of_pages > 1): ?>
				<button
					hx-post="<?php echo e($base_url); ?>?pg=<?php echo e($number_of_pages); ?>"
					class="<?php echo e($current_page == $number_of_pages ? 'active' : ''); ?>"
					aria-label="Page <?php echo e($number_of_pages); ?>">
					<?php echo e($number_of_pages); ?>

				</button>
			<?php endif; ?>
		</div>

		
		<button
			class='next <?php echo e($current_page < $number_of_pages ? '' : 'disabled'); ?>'
			hx-post="<?php echo e($base_url); ?>?pg=<?php echo e($current_page + 1); ?>"
			aria-label="Next">
			<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
				<path d="M12.1716 12.0005L9.3431 14.8289L10.7574 16.2431L15 12.0005L10.7574 7.75781L9.3431 9.17203L12.1716 12.0005Z"
					fill="#292524" />
			</svg>
		</button>
	</div>

<?php endif; ?>
<?php /**PATH /home/ldqrldg/preprod/web/app/themes/lorraine-resine/resources/views/components/pagination.blade.php ENDPATH**/ ?>